<?php
namespace Newland\Toubiz\Brochures\Neos\Controller;

/*
 * This file is part of the "toubiz-brochures-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Neos\Domain\Service\ContentContext;
use Newland\Toubiz\Brochures\Neos\Service\ClientService;
use Newland\Toubiz\Sync\Neos\Domain\Model\BrochureOrder;

class AppController extends ActionController
{
    /**
     * @var ClientService
     * @Flow\Inject
     */
    protected $clientService;
    /**
     * @var array
     * @Flow\InjectConfiguration
     */
    protected $configuration;

    public function indexAction()
    {
        $order = new BrochureOrder();
        $client = $this->getClient();

        $this->view->assignMultiple(
            [
                'order' => $order,
                'client' => $client,
                'layout' => $this->configuration['layout'],
            ]
        );
    }

    private function getClient(): string
    {
        $currentSite = $this->getCurrentSite();

        return $this->clientService->getClient($currentSite);
    }

    private function getCurrentSite(): string
    {
        $currentSite = '';

        /** @var Node $node */
        $node = $this->request->getInternalArgument('__node');
        $context = $node->getContext();

        if ($context instanceof ContentContext) {
            $currentSite = $context->getCurrentSite();
        }
        return $currentSite;
    }
}
