const path = require('path');
const CleanWebpackPlugin = require('clean-webpack-plugin');

module.exports = {
    mode: 'development',

    entry: {
        index: './Resources/Private/Scripts/index.js'
    },

    output: {
        path: path.resolve(__dirname, 'Resources/Public/Scripts'),
        filename: '[name].bundle.js',
        chunkFilename: '[chunkhash].chunk.js',
        publicPath: '/_Resources/Static/Packages/Newland.Toubiz.Brochures.Neos/Scripts/',
    },

    module: {
        rules: [
            {
                test: /.jsx?$/,
                exclude: /node_modules/,
                loader: 'babel-loader',
            }
        ]
    },

    plugins: [
        new CleanWebpackPlugin(),
    ]
};