<?php
namespace Newland\Toubiz\Brochures\Neos\Service;

/*
 * This file is part of the "toubiz-brochures-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Cache\Backend\BackendInterface;
use Neos\Cache\Frontend\FrontendInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;
use Newland\Toubiz\Sync\Neos\Domain\Model\Brochure;
use Newland\Toubiz\Sync\Neos\Domain\Repository\BrochureRepository;
use function Safe\json_encode;

class BrochureService
{
    const CACHE_NAME = 'Newland_Toubiz_Sync_Neos-Brochures';

    /**
     * @var BrochureRepository
     * @Flow\Inject()
     */
    protected $brochureRepository;

    /**
     * @var CacheManager
     * @Flow\Inject()
     */
    protected $cacheManager;

    /**
     * @var FrontendInterface
     */
    protected $cache;

    public function initializeObject(): void
    {
        $this->cache = $this->cacheManager->getCache(self::CACHE_NAME);
    }

    public function getJsonData(string $client): array
    {
        if ($this->cache->has($client) === false) {
            $lifetimeInSeconds = 15 * 60;
            $this->cache->set($client, $this->generateJsonData($client), [], $lifetimeInSeconds);
        }

        return $this->cache->get($client);
    }

    private function generateJsonData(string $client): string
    {
        $brochures = $this->brochureRepository->findAllByClient($client);

        $data = array_map(
            function (Brochure $brochure) {
                return $brochure->jsonSerialize();
            },
            $brochures
        );

        return json_encode($data);
    }
}
