<?php
namespace Newland\Toubiz\Brochures\Neos\Controller;

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\JsonView;
use Newland\Toubiz\Brochures\Neos\Service\BrochureService;
use Newland\Toubiz\Sync\Neos\Domain\Repository\BrochureRepository;

class AjaxBrochureController extends ActionController
{
    /**
     * @var BrochureRepository
     * @Flow\Inject()
     */
    protected $brochureRepository;

    /**
     * @var BrochureService
     * @Flow\Inject()
     */
    protected $brochureService;

    protected $defaultViewObjectName = JsonView::class;

    public function listAction(string $client): void
    {
        $brochures = $this->brochureService->getJsonData($client);
        $this->view->assignMultiple([ 'brochures' => $brochures ]);
    }
}
