<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Tests\Unit\Constants;

use Newland\Toubiz\Api\Tests\Unit\Constants\Mock\FizzBuzz;
use Newland\Toubiz\Api\Tests\Unit\Constants\Mock\FooBarBaz;
use PHPUnit\Framework\TestCase;

class EnumTest extends TestCase
{
    /**
     * @dataProvider provideValidValues
     * @param string $value
     * @param bool $valid
     */
    public function testFiguresOutIfValueIsValid(string $value, bool $valid): void
    {
        $this->assertEquals($valid, FooBarBaz::validValue($value));
    }

    /**
     * @dataProvider provideValidValues
     * @param string $value
     * @param bool $valid
     */
    public function testThrowsIfInvalid(string $value, bool $valid): void
    {
        if (!$valid) {
            $this->expectException(\InvalidArgumentException::class);
        } else {
            // Tests must perform assertions
            $this->assertTrue(true);
        }

        FooBarBaz::throwIfInvalid($value);
    }

    public function testThrowsIfInvalidOnSubsequentEnum():void
    {
        $this->expectException(\InvalidArgumentException::class);
        FooBarBaz::throwIfInvalid('foo');
        FizzBuzz::throwIfInvalid('foo');
    }

    public function testGeneratesNameBasedOnClassName(): void
    {
        $this->assertEquals('FooBarBaz', FooBarBaz::name());
    }

    public function testExtractsValues(): void
    {
        $this->assertEquals([ 'foo', 'bar', 'baz' ], FooBarBaz::values());
    }

    public function valueExtractionOfMultipleEnumsDoesNotCollide(): void
    {
        $this->assertEquals([ 'foo', 'bar', 'baz' ], FooBarBaz::values());
        $this->assertEquals([ 'fizz', 'buzz' ], FizzBuzz::values());
        $this->assertEquals([ 'foo', 'bar', 'baz' ], FooBarBaz::values());
        $this->assertEquals([ 'fizz', 'buzz' ], FizzBuzz::values());
        $this->assertEquals([ 'foo', 'bar', 'baz' ], FizzBuzz::values());
    }

    public function provideValidValues(): array
    {
        return [
            [ 'foo', true ],
            [ 'bar', true ],
            [ 'baz', true ],
            [ 'lalala', false ]
        ];
    }
}
