<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventDate;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use function Safe\preg_replace;
use function Safe\preg_match;

/**
 * Event date adapter.
 */
class EventDateAdapter extends AbstractLegacyObjectAdapter implements EventDateAdapterInterface
{
    /** @var string|null */
    protected $detailUriTemplate;

    public function setDetailUriTemplate(?string $detailUriTemplate): void
    {
        $this->detailUriTemplate = $detailUriTemplate;
    }

    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['dateTypeID']);
    }

    public function getBeginsAt(): \DateTimeInterface
    {
        return $this->buildDateTimeFromStrings($this->object['date'], $this->object['time_begin']);
    }

    public function getEndsAt(): \DateTimeInterface
    {
        if ($this->isEmptyTimeString($this->object['time_end'])) {
            return $this->buildDateTimeFromStrings($this->object['date'], '23:59:59');
        }
        return $this->buildDateTimeFromStrings($this->object['date'], $this->object['time_end']);
    }

    public function getBeginsAtSpecificTime(): bool
    {
        return !$this->isEmptyTimeString($this->object['time_begin']);
    }

    public function getEndsAtSpecificTime(): bool
    {
        return !$this->isEmptyTimeString($this->object['time_end']);
    }

    public function getDetailUri(): ?string
    {
        return null;
    }

    public function getNote(): string
    {
        return strip_tags((string) $this->object['additional_title']);
    }

    /**
     * @param string|mixed $string
     */
    private function isEmptyTimeString($string): bool
    {
        if (!\is_string($string)) {
            return true;
        }

        $withoutWhitespace = preg_replace('/\s/', '', $string);
        if (\is_array($withoutWhitespace)) {
            $withoutWhitespace = implode('', $withoutWhitespace);
        }
        if ($withoutWhitespace === '') {
            return true;
        }

        // It is empty if it contains nothing except 0 and :
        if (preg_match('/[^0:]/', $withoutWhitespace)) {
            return false;
        }

        return true;
    }

    public function isCancelled(): bool
    {
        return false;
    }
}
