<?php declare(strict_types=1);
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\ObjectAdapter\MediumWithStaticPreviewUri;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface, MediumWithStaticPreviewUri
{
    /**
     * @var string
     */
    protected const IMAGE_URL = 'https://img2.oastatic.com/img2/:id/1920x-f/.jpg';

    /**
     * @var string
     */
    protected const PREVIEW_URL = 'https://img2.oastatic.com/img2/:id/600x-f/.jpg';

    /**
     * @var integer
     */
    protected $sorting;

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return TourAttributes::DATA_SOURCE_OUTDOOR_ACTIVE . '_' . $this->object['id'];
    }

    public function getSourceUri(): string
    {
        if ($this->object['isVideo'] ?? false) {
            if ($this->object['video']['youtubeId']) {
                return 'https://www.youtube.com/watch?v=' . $this->object['video']['youtubeId'];
            }
        }

        return str_replace(':id', (string) $this->object['id'], self::IMAGE_URL);
    }

    public function getPreviewUri(): ?string
    {
        if ($this->object['isVideo'] ?? false) {
            return str_replace(':id', (string) $this->object['id'], self::IMAGE_URL);
        }

        return str_replace(':id', (string) $this->object['id'], self::PREVIEW_URL);
    }

    public function getCopyright(): ?string
    {
        $copyright = $this->object['source'] ?? null;
        return $copyright ? strip_tags((string) $copyright) : null;
    }

    public function getTitle(): ?string
    {
        $title = $this->object['title'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }

    public function getType(): string
    {
        $isVideo = $this->object['isVideo'] ?? false;
        return $isVideo ? MediumConstants::TYPE_VIDEO : MediumConstants::TYPE_IMAGE;
    }

    public function getAltText(): ?string
    {
        return null;
    }

    public function getDescription(): ?string
    {
        return null;
    }
}
