<?php
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;

class AddressAdapter extends AbstractObjectAdapter implements AddressAdapterInterface
{
    public function getTitle(): ?string
    {
        return '';
    }

    public function getFirstName(): ?string
    {
        return '';
    }

    public function getLastName(): ?string
    {
        return '';
    }

    public function getStreet(): ?string
    {
        return '';
    }

    public function getZip(): ?string
    {
        return '';
    }

    public function getCity(): ?string
    {
        return '';
    }

    public function getCountry(): ?string
    {
        return '';
    }

    public function getPhoneNumber(): ?string
    {
        return '';
    }

    public function getFaxNumber(): ?string
    {
        return '';
    }

    public function getEmailAddress(): ?string
    {
        return '';
    }

    public function getWebsiteAddress(): ?string
    {
        return '';
    }

    public function getExternalId(): string
    {
        return md5($this->object['startingPoint']['lat'] . ':' . $this->object['startingPoint']['lon']);
    }

    public function isLookup(): bool
    {
        return true;
    }

    public function getLatitude(): ?float
    {
        $latitude = $this->object['startingPoint']['lat'] ?? null;
        $latitude = $latitude ?: $this->object['firstGeometry']['lat'] ?? null;
        return $latitude ? ((float) $latitude) : null;
    }

    public function getLongitude(): ?float
    {
        $longitude = $this->object['startingPoint']['lon'] ?? null;
        $longitude = $longitude ?: $this->object['firstGeometry']['lon'] ?? null;
        return $longitude ? ((float) $longitude) : null;
    }
}
