# Toubiz API package

Provides functionality to connect to the Toubiz API's.

## Usage

```
use Newland\Toubiz\Api\Repository\EventRepository;
use Newland\Toubiz\Api\Service\ServiceCollection;
use Newland\Toubiz\Api\Service\ServiceFactory;

// Get service for "old" toubiz API.
$service = ServiceFactory::get('Toubiz/Legacy/Api');

// Configure service.
$service->setClientName('foo');
$service->setApiKey('0000');

// Create a new service collection.
$serviceCollection = new ServiceCollection();

/*
 * Add service to the collection.
 *
 * You can configure various services and add them to the collection.
 * Each repository fetches data from the appropriate service that
 * is configured and added to the collection.
 */
$serviceCollection->add($service);

// Instantiate event repository for fetching events
$repository = new EventRepository($serviceCollection);

// Alternative way if you don't pass a service to the class constructor.
$repository->setServiceCollection($serviceCollection);

// Fetch all active events.
$eventList = $eventRepository->findAllActiveEvents();
```
