<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService;

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['id']);
    }

    public function getSourceUri(): string
    {
        return strip_tags((string) $this->object['reference']);
    }

    public function getCopyright(): ?string
    {
        $copyright = $this->object['copyright'] ?? null;
        return $copyright ? strip_tags($copyright) : null;
    }

    public function getTitle(): ?string
    {
        $title = $this->object['title'] ?? null;
        return $title ? strip_tags($title) : null;
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getAltText(): ?string
    {
        return null;
    }

    public function getDescription(): ?string
    {
        return null;
    }

    public function getFocusPointX(): ?int
    {
        return null;
    }

    public function getFocusPointY(): ?int
    {
        return null;
    }
}
