<?php
namespace Newland\Toubiz\Api\Utility;

use Psr\Log\LoggerAwareTrait;

class RetryPool
{
    use LoggerAwareTrait;

    const SECOND_TO_MICROSECONDS = 1000000;

    /** @var int */
    private $maxRetries;

    /** @var int */
    private $sleepSecondsBeforeRetry;

    public function __construct(int $maxRetries, int $sleepSecondsBeforeRetry = 3)
    {
        $this->maxRetries = $maxRetries;
        $this->sleepSecondsBeforeRetry = $sleepSecondsBeforeRetry;
    }

    public function retryOnException(callable $block)
    {
        $retries = 0;
        $lastException = null;
        do {
            try {
                return $block();
            } catch (\Exception $e) {
                $retries++;
                $lastException = $e;
                $this->logger->warning(
                    'Action failed: ' . $e->getMessage()
                    . '. Retrying in ' . $this->sleepSecondsBeforeRetry . ' seconds'
                );
                usleep($this->sleepSecondsBeforeRetry * static::SECOND_TO_MICROSECONDS);
            }
        } while ($retries < $this->maxRetries);

        throw $lastException;
    }
}
