<?php

namespace Newland\Toubiz\Api\Service\Toubiz\Brochures;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\BrochureFilterConfigurationAdapterInterface;
use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureFilterConfigurationAdapter;

class ApiService extends AbstractService
{

    /**
     * @var string Base URI of API endpoint.
     */
    const DEFAULT_BASE_URI = 'https://api.toubiz.de/json/';

    /**
     * Time in seconds of the last modified time interval
     * to fetch data from brochures in secods
     *
     */
    const LAST_MODIFIED_INTERVAL = 86400000;


    /**
     * Fetches Brochures.
     *
     * @param callable $block
     * @return array
     */
    public function fetchBrochureList(callable $block)
    {
        $brochuresDataRaw = $this->getDataFromApi();

        $brochures = [];
        foreach ($brochuresDataRaw as $brochure) {
            $brochureAdapter = new BrochureAdapter($brochure);
            if ($brochureAdapter->getFlagStatus() !== 1) {
                $brochures[] = $block($brochureAdapter);
            }
        }

        return $brochures;
    }

    public function fetchBrochureConfiguration(): BrochureFilterConfigurationAdapterInterface
    {
        return new BrochureFilterConfigurationAdapter($this->getConfigDataFromApi());
    }

    private function getDataFromApi(): array
    {
        $response = $this->httpClient->request('GET', $this->getListUri());
        if ($response->getStatusCode() === 200) {
            $data = json_decode($response->getBody(), true);
            return $data['result']['item'] ?? [];
        }

        return [];
    }

    private function getConfigDataFromApi(): array
    {
        $uri = self::DEFAULT_BASE_URI . 'prospekt/mandantConfig.php?mandant=' . $this->clientName;
        $response = $this->httpClient->request('GET', $uri);
        if ($response->getStatusCode() === 200) {
            return json_decode($response->getBody(), true) ?? [];
        }

        return [];
    }

    private function getListUri(): string
    {
        $parameters = [
            ':apiKey' => $this->apiKey,
            ':limit' => 100,
            ':modified' => self::LAST_MODIFIED_INTERVAL,
        ];

        $uri = str_replace(
            array_keys($parameters),
            $parameters,
            self::DEFAULT_BASE_URI . 'prospekt/modified.php?key=:apiKey&limit=:limit&modified=:modified'
        );

        return $uri;
    }
}
