<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Event date adapter interface.
 *
 * Defines the interface for all event date adapters
 * representing a date for an event record from Toubiz.
 */
interface EventDateAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the start date and time of an event day.
     *
     * @return \DateTime
     */
    public function getBeginsAt();

    /**
     * Returns the end date and time of an event day.
     *
     * @return \DateTime
     */
    public function getEndsAt();

    /**
     * Returns an informational note for this date.
     *
     * @return string
     */
    public function getNote();
}
