<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Event date adapter interface.
 *
 * Defines the interface for all event date adapters
 * representing a date for an event record from Toubiz.
 */
interface EventDateAdapterInterface extends ObjectAdapterInterface
{
    public function getBeginsAt(): \DateTimeInterface;
    public function getEndsAt(): \DateTimeInterface;
    public function getBeginsAtSpecificTime(): bool;
    public function getEndsAtSpecificTime(): bool;


    /**
     * Returns an informational note for this date.
     *
     * @return string
     */
    public function getNote();

    /**
     * Returns the URI for buying a ticket.
     *
     * @return string|null
     */
    public function getDetailUri();
}
