<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventDate;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventDateAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class EventDateFactory
{

    /**
     * Mapping of channel id to detailUriTemplates keys.
     */
    private static $eventDetailTemplateMapping = [
        'rce_event_fid' => 'rce',
    ];

    public static function get(array $data, ?string $channelId, array $detailUriTemplates)
    {
        $adapter = static::initialize($channelId, $data);
        $adapter->setDetailUriTemplate(static::getDetailUriTemplate($detailUriTemplates, $channelId));
        return $adapter;
    }

    private static function initialize(?string $channelId, array $data)
    {
        switch ($channelId) {
            case 'rce_event_fid':
                return new RceDateAdapter($data);
            default:
                return new EventDateAdapter($data);
        }
    }

    private static function getDetailUriTemplate(array $detailUriTemplates, ?string $channelId)
    {
        $key = static::$eventDetailTemplateMapping[$channelId] ?? null;
        return $detailUriTemplates[$key] ?? $detailUriTemplates[$channelId] ?? null;
    }
}
