<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter\WeatherAdapter;

class ApiService extends AbstractService
{
    public const DEFAULT_BASE_URI = 'http://api.openweathermap.org/data/2.5/forecast';

    /**
     * @var bool
     */
    private $debug = false;

    public function fetchForecast(callable $block): void
    {
        foreach ($this->parameters['locations'] as $locationName => $coordinates) {
            if (!$coordinates['lat'] || !$coordinates['lon']) {
                continue;
            }

            $weatherData = $this->getForecastForLocation($coordinates);
            $block(new WeatherAdapter($locationName, $weatherData));
        }
    }

    private function getForecastForLocation(array $coordinates)
    {
        if ($this->debug) {
            return $this->getDummyData();
        }

        return $this->getDataFromApi($coordinates);
    }

    private function getDataFromApi(array $coordinates): array
    {
        $response = $this->httpClient->get(
            self::DEFAULT_BASE_URI,
            [
                'query' => [
                    'lat' => $coordinates['lat'],
                    'lon' => $coordinates['lon'],
                    'apiKey' => $this->apiKey,
                    'units' => 'metric',
                ],
            ]
        );

        return json_decode($response->getBody(), true);
    }

    private function getDummyData()
    {
        $json = (string) file_get_contents(
            __DIR__ . '/../../../Tests/Fixtures/WeatherData/openWeatherMap.json'
        );

        return json_decode($json, true);
    }
}
