<?php
namespace Newland\ToubizApi\Tests\Service\Toubiz\Legacy\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Attributes\PointOfInterestAttributes;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService\CategoryAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService\PointOfInterestAdapter;
use PHPUnit\Framework\TestCase;

class PointOfInterestAdapterTest extends TestCase
{
    public function testMoveMainCategoryToTop(): void
    {
        $categories = [
            new CategoryAdapter([ 'remote_id' => 'foo', 'name' => 'Secondary Category A' ]),
            new CategoryAdapter([ 'remote_id' => 'baz', 'name' => 'Main Category' ]),
            new CategoryAdapter([ 'remote_id' => 'bar', 'name' => 'Secondary Category B' ]),
        ];

        $mainCategoryId = 'baz';

        $categories = (new PointOfInterestAdapter(new \stdClass(), new CategoryMap([])))
            ->moveMainCategoryToTop($categories, $mainCategoryId);

        $this->assertEquals('baz', $categories[0]->getExternalId());
    }

    public function testImportsMultipleTagsAsMultipleAttributes(): void
    {
        $adapter = new PointOfInterestAdapter(
            [
                'remote_id' => 'foo',
                'object' => [
                    'data_map' => [
                        'tags' => [
                            'content' => 'foo,bar,baz',
                            'datatypestring' => 'ezselection',
                        ],
                    ],
                ],
            ], new CategoryMap([])
        );

        $attributes = $adapter->getAttributes();
        $this->assertCount(3, $attributes);
        $this->assertEquals(PointOfInterestAttributes::TAG, $attributes[0]->getName());
        $this->assertEquals(PointOfInterestAttributes::TAG, $attributes[1]->getName());
        $this->assertEquals(PointOfInterestAttributes::TAG, $attributes[2]->getName());
        $this->assertEquals('foo', $attributes[0]->getData());
        $this->assertEquals('bar', $attributes[1]->getData());
        $this->assertEquals('baz', $attributes[2]->getData());
    }

    public function testImportsThermalWaterTypeAsMultipleAttributes(): void
    {
        $adapter = new PointOfInterestAdapter(
            [
                'remote_id' => 'foo',
                'object_children_list' => [
                    [
                        'therme_extension' => [
                            'object' => [
                                'data_map' => [
                                    'wasser' => [
                                        'content' => 'foo,bar,baz',
                                        'datatypestring' => 'ezselection',
                                    ],
                                ]
                            ]
                        ]
                    ]
                ]
            ], new CategoryMap([])
        );

        $attributes = $adapter->getAttributes();
        $this->assertCount(3, $attributes);
        $this->assertEquals(PointOfInterestAttributes::THERMAL_WATERTYPE, $attributes[0]->getName());
        $this->assertEquals(PointOfInterestAttributes::THERMAL_WATERTYPE, $attributes[1]->getName());
        $this->assertEquals(PointOfInterestAttributes::THERMAL_WATERTYPE, $attributes[2]->getName());
        $this->assertEquals('foo', $attributes[0]->getData());
        $this->assertEquals('bar', $attributes[1]->getData());
        $this->assertEquals('baz', $attributes[2]->getData());
    }

    public function testImportsMultipleFeatureListItemsAsMultipleAttributes(): void
    {
        $adapter = new PointOfInterestAdapter(
            [
                'remote_id' => 'foo',
                'object' => [
                    'data_map' => [
                        'feature' => [
                            [ 'content' => 'foo', 'parent_id' => 'd9fb978199b5a88bc6205ed79e75c9f0' ],
                            [ 'content' => 'bar', 'parent_id' => 'd9fb978199b5a88bc6205ed79e75c9f0' ],
                            [ 'content' => 'baz', 'parent_id' => 'e4506d15ec7dd2200fb01c6e0484493e' ],
                        ]
                    ],
                ],
            ], new CategoryMap([])
        );

        $attributes = $adapter->getAttributes();
        $this->assertCount(3, $attributes);
        $this->assertEquals('foo', $attributes[0]->getData());
        $this->assertEquals('bar', $attributes[1]->getData());
        $this->assertEquals('baz', $attributes[2]->getData());
        $this->assertEquals(PointOfInterestAttributes::INFORMATION, $attributes[0]->getName());
        $this->assertEquals(PointOfInterestAttributes::INFORMATION, $attributes[1]->getName());
        $this->assertEquals(PointOfInterestAttributes::ACCEPTED_PAYMENTS, $attributes[2]->getName());
    }

    public function testMapsPriceTable(): void
    {
        $adapter = new PointOfInterestAdapter(
            [
                'remote_id' => 'foo',
                'object' => [
                    'data_map' => [
                        'prices' => [
                            'datatypestring' => 'ezmatrix',
                            'content' => [
                                [ 'foo', 'bar', 'baz' ],
                                [ 'second', 'row', 'here' ]
                            ]
                        ]
                    ],
                ],
            ], new CategoryMap([])
        );

        $this->assertCount(1, $adapter->getAttributes());
        $this->assertEquals(PointOfInterestAttributes::PRICES, $adapter->getAttributes()[0]->getName());
        $this->assertEquals(
            [
                [ 'foo', 'bar', 'baz' ],
                [ 'second', 'row', 'here' ]
            ],
            $adapter->getAttributes()[0]->getData()
        );
    }
}
