<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\Service\Tportal\ObjectAdapter\LodgingAdapter;
use PHPUnit\Framework\TestCase;

class LodgingAdapterTest extends TestCase
{

    // See TBPOI-377
    public function testUsesCompanyName(): void
    {
        $adapter = new LodgingAdapter([
            'housedata' => [
                'out' => [
                    'address' => [
                        'companyName1' => 'Foo'
                    ]
                ]
            ]
        ]);

        $this->assertEquals('Foo', $adapter->getName());
    }


    // See TBPOI-377
    public function testConcatenatesCompanyNamesIfMultipleAvailable(): void
    {
        $adapter = new LodgingAdapter([
              'housedata' => [
                  'out' => [
                      'address' => [
                          'companyName1' => 'Foo',
                          'companyName2' => 'Bar',
                          'companyName3' => 'Baz',
                      ]
                  ]
              ]
          ]);

        $this->assertEquals('Foo, Bar, Baz', $adapter->getName());
    }

}
