# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]
### Fixed
- Removes strip tags for DataMapString content.
- Gps file parsing has been outsourced to `newland/gps-file-parsing`. This fixes 2 issues that resulted in tours not beeing imported:
    - Errors when parsing the GPS file would abort importing the current item: From now on errors when parsing the GPS track will be logged but will not abort imports anymore.
    - Segmented GPX files would not be parsed correctly.

## [1.14.5] - 2019-11-20
### Fixed
- Fixed legacy toubiz not mapping `ezmatrix` attribute types (e.g. price tables)
- Errors while requesting API endpoints are now correctly re-thrown to the outside.
- `dv_special` for direct marketers from legacy toubiz is now mapped into the attribute name `services` instead of `commodities`. This makes the attribute consistent with other article types.
- Requests are now retried correctly on errors
- Removes strip tags for DataMapString content. 

### Changed
- Lodgings from tportal now use the company name as their name if available.
- More detailed error messages for errors during API requests.

## [1.14.4] - 2019-10-02
### Fixed
- Packages with no description can now be imported. 
- Adapters now strip tags out of strings that shouldn't contain HTML.

## [1.14.0] - 2019-09-17

## [1.13.0] - 2019-08-01
### Added
- API Requests are now executed concurrently. The `concurrency` parameter can be set in order
  to control how many requests should be executed at once.
- All ApiServices now return an `ServiceResult` object containing either the ids of all existing
  objects in the database or an array of all deleted objects in the database.
- Most ApiServices now support a `modified` parameter to only handle object that have been modified
  in a given time frame.


## [1.12.0] - 2019-07-12
### Fixed
- For cities with no geo coordinates the weather import is now skipped.
- Fixed filters without article main type not including congress locations and cities.
  This mostly only applies to housekeeping and internal queries.
- Fixed stripping to many common characters from API responses leading to them missing in
  articles fields such as descriptions.

## [1.10.2] - 2019-06-19
### Fixed
- Fixed parsing of lodging star ratings in some instances.

## [1.10.0] - 2019-06-07
### Added
- Opening times for gastronomy is now imported.
- External event IDs (e.g. from RCE) are now imported and could be used for external detail pages.

### Changed
- Default pagesize of legacy toubiz `DbService` is now 25 instead of 10
- Categories of articles from legacy toubiz `DbService` are now sorted. Main category comes first.

## [1.8.1] - 2019-05-14
### Fixed
- Language of OutdoorActive entities is now correctly passed to the adapter

## [1.8.0] - 2019-05-08
### Added
- Import services can now retry multiple times on failure. Implemented for:
    - Tportal
    - Toubiz legacy DBService
- Import services can now be passed a limit parameter for testing.
- New string method to clean invalid UTF Code `StringCleaner::asString((string) $data);`
- The following API Services are now language aware:
    - Toubiz legacy DBService
    - Toubiz legacy event API
    - Toubiz legacy gastronomy
    - Toubiz legacy direct marketers
    - Outdoor active tours
- The static category map has now translations into 8 languages. The correct language is used
if available.

### Changed
- String Cleaner uses the current formats received.
- PHP 7.1 and up is now required.
- Raw data from Toubiz is now sanitized before parsed as json.

## [1.7.1] - 2019-04-18
### Fixed
- Links only containing `http://` are now being ignored

## [1.7.0] - 2019-04-17
### Added
- Services and adapters for communication to the legacy toubiz API
- Ability to parse redirect URIs as generated by the brochure module of legacy toubiz.
- The following new information is now being fetched:
  - Events
    - ticket contact information
    - additional information
  - Direct Marketers from legacy toubiz
    - social links(facebook, twitter, instagram, youtube, flickr)
    - attributes
    - All categories (instead of just the main category)

### Fixed
- String Cleaner now parses self closing tags like `<br>` and `<hr>`.

## [1.6.0] - 2019-04-02
### Added
- Address adapters can now signal that part of their data (e.g. zip-code) should be
  looked up from an external data source (e.g. google).
- The following new tour attributes are now fetched:
    - `directions`
    - `parking`
    - `additionalInformation`
- Additional Information for SnowReports can now be fetched from the API.
- APIServices can now specify a custom `baseUri` as constructor argument.

### Fixed
- Some Adapters incorrectly returned `null`. These returns have either been removed or
  explicitly annotated.
- Only direct marketers marked with `online=1` are now imported from legacy toubiz.
- Calls to Toubiz legacy Event API are now paginated to prevent running into memory issues
  or timeouts.
- TPortal Lodging requests are now retried up to 5 times if they fail in order to cope
  with random failures in TPortal.

### Changed
- Article Adapters now do not have address data themselves, but expose a main address via
  the `getMainAddress` method.
- APIServices are now logger aware: A PSR Logger interface can be passed to them using the
  `setLogger` method.

## [1.5.0] - 2019-03-08
### Added
- New fields are now being imported for outdooractive tours:
    - labels (`top`, `publicTransportFriendly`, ...)
- Media elements from outdooractive are now aware of their sorting
