<?php declare(strict_types=1);


namespace Newland\Toubiz\Api\Service\GpsParser;

/**
 * Parser for the GPX file format
 */
class GpxParser extends Parser
{
    /**
     * This function takes a raw array and extracts each track point to a formatted object
     * The resulting array of objects (points) can be used to calculate multiple things
     * TODO: Handle multiple track segments
     *
     * @param string $file
     * @return array
     */
    public function extractTrack(string $file): array
    {
        $array = $this->parseXmlAsAssociativeArray($file);
        $track = [];

        // Extracting all points from the GPX data set
        foreach ($array['trk']['trkseg']['trkpt'] as $trackPoint) {
            $point = [
                (float) $trackPoint['@attributes']['lat'],
                (float) $trackPoint['@attributes']['lon'],
            ];
            $track[] = $point;
        }

        // Save the list of points
        return $track;
    }
}
