<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

/**
 * Address adapter.
 *
 * This one is specifically for the tportal gastro endpoint.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return (string) $this->object['remote_id'];
    }

    public function getTitle(): ?string
    {
        if (!empty($this->object['address']['name'] ?? null)) {
            return $this->object['address']['name'];
        }
        return $this->object['address']['Title'] ?? null;
    }

    public function getFirstName(): ?string
    {
        return $this->object['address']['firstname'] ?? null;
    }

    public function getLastName(): ?string
    {
        return $this->object['address']['lastname'] ?? null;
    }

    public function getStreet(): ?string
    {
        return $this->object['address']['street'] ?? null;
    }

    public function getZip(): ?string
    {
        $value = $this->object['address']['zip'] ?? null;
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    public function getCity(): ?string
    {
        return $this->object['address']['city'] ?? null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->object['address']['phone1'] ?? null;
    }

    public function getFaxNumber(): ?string
    {
        return $this->object['address']['fax'] ?? null;
    }

    public function getEmailAddress(): ?string
    {
        return $this->object['address']['email'] ?? null;
    }

    public function getWebsiteAddress(): ?string
    {
        $url = $this->object['address']['internet'] ?? null;

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return '';
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getLatitude(): ?float
    {
        return $this->object['location']['Latitude'] ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->object['location']['Longitude'] ?? null;
    }

    public function isLookup(): bool
    {
        return false;
    }
}
