<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['id'];
    }

    public function getSourceUri(): string
    {
        return $this->object['reference'];
    }

    public function getCopyright(): ?string
    {
        return $this->object['copyright'] ?? null;
    }

    public function getTitle(): ?string
    {
        return $this->object['title'] ?? null;
    }
}
