<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return (string) $this->object['object']['id'];
    }

    /**
     * @return string|null
     */
    public function getTitle()
    {
        return $this->object['object']['data_map']['address_title']['content'];
    }

    /**
     * @return string|null
     */
    public function getFirstName()
    {
        return null;
    }

    /**
     * @return string|null
     */
    public function getLastName()
    {
        return null;
    }

    /**
     * @return string|null
     */
    public function getStreet()
    {
        $value = $this->object['object']['data_map']['street']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getZip()
    {
        $value = $this->object['object']['data_map']['zip']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getCity()
    {
        $value = $this->object['city'] ?? null;
        if ($value) {
            return $value;
        }

        $value = $this->object['object']['data_map']['city']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->object['object']['data_map']['phone']['content'] ?? null;
    }

    /**
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->object['object']['data_map']['fax']['content'] ?? null;
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->object['object']['data_map']['email']['content'] ?? null;
    }

    /**
     * @return string|null
     */
    public function getWebsiteAddress()
    {
        $url = $this->object['object']['data_map']['url']['content'];

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    /**
     * @return float|null
     */
    public function getLatitude(): ?float
    {
        $latitude = $this->object['object']['data_map']['geodata']['content']['latitude'] ?? null;

        if ($latitude) {
            return (float) $latitude;
        }

        return null;
    }

    /**
     * @return float|null
     */
    public function getLongitude(): ?float
    {
        $latitude = $this->object['object']['data_map']['geodata']['content']['longitude'] ?? null;

        if ($latitude) {
            return (float) $latitude;
        }

        return null;
    }

    public function isLookup(): bool
    {
        return true;
    }
}
