<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\Service\Tportal\ObjectAdapter\LodgingAdapter;
use PHPUnit\Framework\TestCase;

class LodgingAdapterTest extends TestCase
{

    /**
     * @dataProvider provideStarClassificationStrings
     */
    public function testExtractsStarRatings($external, $expected): void
    {
        $lodging = new LodgingAdapter(
            [
                'housedata' => [
                    'out' => [
                        'dataClassAttributeValues' => [
                            [
                                'twsDataClassAttribute' => [
                                    'name' => 'ClassificationServiceProvider'
                                ],
                                'twsLookupValues' => [
                                    'value' => $external
                                ]
                            ],
                        ],
                    ],
                ],
            ]
        );

        $this->assertEquals($expected, $lodging->getStarClassification());
    }

    public function testHandlesMissingStarRatingsCorreclty(): void
    {
        $lodging = new LodgingAdapter(
            [
                'housedata' => [
                    'out' => [
                        'dataClassAttributeValues' => null,
                    ],
                ],
            ]
        );

        $this->assertEquals(null, $lodging->getStarClassification());
    }

    public function provideStarClassificationStrings(): array
    {
        return [
            [ '4 Sterne Superior', 4 ],
            [ 'F***', 3 ],
            [ 'foobar', null ],
            [ 2, 2 ],
            [ '4', 4 ],
            [ null, null ]
        ];
    }
}
