<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Abstract object adapter.
 */
abstract class AbstractObjectAdapter
{
    /**
     * @var mixed Adapted object.
     */
    protected $object;

    /**
     * Constructor.
     *
     * @param mixed $adaptee The adapted object.
     * @return void
     */
    public function __construct($adaptee = null)
    {
        $this->setObject($adaptee);
    }

    /**
     * Adaptee setter.
     *
     * @param mixed $adaptee The adapted object.
     * @return void
     */
    public function setObject($adaptee)
    {
        $this->object = $adaptee;
    }
}
