<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['id'];
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return $this->object['reference'];
    }

    /**
     * @return string
     */
    public function getCopyright()
    {
        return $this->object['copyright'];
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->object['title'];
    }
}
