<?php
namespace Newland\ToubizApi\Tests\Unit\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;


use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\CityAttributes;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService\CityAdapter;
use PHPUnit\Framework\TestCase;

class CityAdapterTest extends TestCase
{

    /**
     * @dataProvider citiesApiResponseDataProvider
     * @param array $data
     */
    public function testHasNoBookingUri(array $data): void
    {
        $adapter = new CityAdapter($data);
        $this->assertNull($adapter->getBookingUri());
    }

    /**
     * @dataProvider citiesApiResponseDataProvider
     * @param array $data
     */
    public function testHasNoDetailUri(array $data): void
    {
        $adapter = new CityAdapter($data);
        $this->assertNull($adapter->getDetailUri());
    }

    /**
     * @dataProvider citiesApiResponseDataProvider
     * @param array $data
     */
    public function testMapsMediaIntoAdapters(array $data): void
    {
        $adapter = new CityAdapter($data);
        $this->assertGreaterThan(0, $adapter->getMedia());
        foreach ($adapter->getMedia() as $medium) {
            $this->assertInstanceOf(MediumAdapterInterface::class, $medium);
        }
    }

    /**
     * @dataProvider citiesApiResponseDataProvider
     * @param array $data
     */
    public function testUsesConstantsAsAttributeNames(array $data): void
    {
        $constantValues = (new \ReflectionClass(CityAttributes::class))->getConstants();

        $adapter = new CityAdapter($data);
        $this->assertGreaterThan(0, $adapter->getAttributes());
        foreach ($adapter->getAttributes() as $attribute) {
            $this->assertInstanceOf(AttributeAdapterInterface::class, $attribute);
            $this->assertContains($attribute->getName(), $constantValues, 'Attribute names must be in CityAttributes');
        }
    }


    public function citiesApiResponseDataProvider(): array
    {
        $json = json_decode(file_get_contents(__DIR__ . '/../../../../../../Fixtures/ToubizLegacyData/cityData.json'), true);
        return array_map(
            function(array $child) { return [ $child ]; },
            $json['content']['children_list']
        );
    }

    public function provideInvalidAndValidUrls(): array
    {
        return [
            [false, 'HaTeTePeEs://www.example.com'],
            [false, 'http//www.example.com'],
            [false, '://www.example.com'],
            [false, 'example.com disjunct'],

            [true, 'https://example.com'],
            [true, 'http://www.example.com'],
            [true, 'www.example.com/file.php?value=1'],
            [true, 'example.com#main'],
        ];
    }

    public function provideCitiesApiResponsesAndUrls(): array
    {
        $cities = $this->citiesApiResponseDataProvider();
        $urls = $this->provideInvalidAndValidUrls();
        $combined = [];
        foreach ($cities as $city) {
            foreach ($urls as $url) {
                $combined[] = [ $city[0], $url[0], $url[1] ];
            }
        }
        return $combined;
    }

    /**
     * @dataProvider provideCitiesApiResponsesAndUrls
     * @param array $data
     * @param bool $valid
     * @param string $url
     */
    public function testDismissesInvalidUrlsForSocialLinks(array $data, bool $valid, string $url): void
    {
        $data['object']['data_map']['flickr'] = [ 'content' => $url ];
        $adapter = new CityAdapter($data);

        if ($valid) {
            $this->assertEquals($url, $adapter->getFlickrUri());
        } else {
            $this->assertNull($adapter->getFlickrUri());
        }
    }

}
