<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\OutdoorActive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter\TourAdapter;

class TourAdapterTest extends UnitTestCase
{
    /**
     * @var TourAdapter
     */
    protected $subject;

    public function setUp()
    {
        $data = json_decode(file_get_contents(__DIR__ . '/../../../../Fixtures/OutdoorActiveData/tour13025479.json'), true);
        $this->subject = new TourAdapter($data['tour'][0]);
    }

    public function testFirstImageIsNotReplacedByPrimaryImage(): void
    {
        $media = $this->subject->getMedia();
        $this->assertEquals('outdooractive_8581583', $media[0]->getExternalId());
    }

    public function testPrimaryImageIsNotFirstImage(): void
    {
        $this->assertEquals('outdooractive_8581637', $this->subject->getMainMedium()->getExternalId());
    }
}
