<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\OutdoorActive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter\TourAdapter;

class TourAdapterTest extends UnitTestCase
{
    /**
     * @var TourAdapter
     */
    protected $subject;

    public function setUp()
    {
        $this->subject = new TourAdapter(
            simplexml_load_string(
                file_get_contents(__DIR__ . '/../../../../Fixtures/OutdoorActiveData/tour10002963.xml')
            )
        );
    }

    public function testFirstImageIsNotReplacedByPrimaryImage(): void
    {
        $media = $this->subject->getMedia();
        $this->assertEquals('outdooractive_10107732', $media[0]->getExternalId());
    }

    public function testPrimaryImageIsNotFirstImage(): void
    {
        $this->assertEquals('outdooractive_10107730', $this->subject->getMainMedium()->getExternalId());
    }
}
