<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\Utility\UrlConverter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return (string) $this->object['ID'];
    }

    public function getSourceUri(): ?string
    {
        return UrlConverter::forceHttps($this->object['url'] ?? null);
    }

    public function getCopyright(): ?string
    {
        return $this->object['copyrightHolder'] ?? null;
    }

    public function getTitle(): ?string
    {
        return $this->object['comment'] ?? null;
    }
}
