<?php
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;

class AddressAdapter extends AbstractObjectAdapter implements AddressAdapterInterface
{
    public function getTitle()
    {
        return '';
    }

    public function getFirstName()
    {
        return '';
    }

    public function getLastName()
    {
        return '';
    }

    public function getStreet()
    {
        return '';
    }

    public function getZip()
    {
        return '';
    }

    public function getCity()
    {
        return '';
    }

    public function getPhoneNumber()
    {
        return '';
    }

    public function getEmailAddress()
    {
        return '';
    }

    public function getWebsiteAddress()
    {
        return '';
    }

    public function getExternalId(): string
    {
        return md5($this->object->tour->startingPoint['lat'] . ':' . $this->object->tour->startingPoint['lon']);
    }

    public function isLookup(): bool
    {
        return true;
    }

    /**
     * @return float|null
     */
    public function getLatitude()
    {
        $latitude = ((float) $this->object->tour->startingPoint['lat']) ?: null;
        if (!$latitude) {
            return $this->object->firstGeometry->lat ?? null;
        }
        return $latitude;
    }

    /**
     * @return float|null
     */
    public function getLongitude()
    {
        $longitude = ((float) $this->object->tour->startingPoint['lon']) ?: null;
        if (!$longitude) {
            return $this->object->firstGeometry->lon ?? null;
        }
        return $longitude;
    }
}
