<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\EntityListAdapterInterface;

class EntityListAdapter implements EntityListAdapterInterface
{
    /**
     * @var string
     */
    protected $type;
    /**
     * @var string
     */
    protected $title;
    /**
     * @var array
     */
    protected $identifiers;

    public function __construct(string $type, string $title, array $identifiers)
    {
        $this->type = $type;
        $this->title = $title;
        $this->identifiers = $identifiers;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getIdentifiers(): array
    {
        return $this->identifiers;
    }
}
