<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\PackageAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;

class PackageAdapter extends AbstractObjectAdapter implements PackageAdapterInterface
{
    use LanguageAware;

    /**
     * Returns the external id used by the API
     * to identify the record.
     *
     * @return string
     */
    public function getExternalId(): string
    {
        return (string) ($this->object['package']['packageID'] ?? '');
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return (string) ($this->object['package']['packageName'] ?? '');
    }

    /**
     * @return string|null
     */
    public function getPreviewImage()
    {
        return $this->object['package']['previewImageURL'] ?? null;
    }

    /**
     * @return string[]
     */
    public function getBenefits(): array
    {
        $description = $this->getDescription('DESCRIPTION_INCLUDED_SERVICES');
        $document = new \DOMDocument();

        if (!$description || !$document->loadHTML($description)) {
            return [];
        }

        $benefits = [];
        foreach ($document->getElementsByTagName('li') as $listItem) {
            $benefits[] = trim($listItem->nodeValue);
        }
        return $benefits;
    }

    /**
     * @return float|null
     */
    public function getMinimumNights()
    {
        return $this->object['package']['minimumNights'] ?? null;
    }

    /**
     * @return float|null
     */
    public function getStartingPrice()
    {
        $group = $this->getFeatureGroup('packageprice');
        if ($group) {
            return $group['features']['number'] ?? null;
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getStartingPriceCurrency()
    {
        return 'EUR';
    }

    private function getFeatureGroup(string $externalId)
    {
        foreach ($this->object['serviceData']['featureGroups'] as $featureGroup) {
            $featureExternalId = $featureGroup['features']['value']['externalID'] ?? null;
            if ($externalId === $featureExternalId) {
                return $featureGroup;
            }
        }
        return null;
    }

    private function getDescription(string $externalId)
    {
        foreach ($this->object['serviceData']['descriptions'] ?? [] as $description) {
            $descriptionExternalId = $description['externalID'] ?? null;
            if ($externalId === $descriptionExternalId) {
                return $description['description'];
            }
        }
        return null;
    }
}
