<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    public function getStreet()
    {
        return $this->object['housedata']['out']['address']['street'];
    }

    public function getZip()
    {
        return $this->object['housedata']['out']['address']['zipCode'];
    }

    public function getCity()
    {
        return $this->object['housedata']['out']['address']['city'];
    }

    public function getCountry()
    {
        return $this->object['housedata']['out']['address']['country']['name'];
    }

    public function getLatitude()
    {
        return $this->object['housedata']['out']['address']['gmapsLatitude'] ?: null;
    }

    public function getLongitude()
    {
        return $this->object['housedata']['out']['address']['gmapsLongitude'] ?: null;
    }

    public function isLookup(): bool
    {
        return true;
    }

    public function getExternalId(): string
    {
        return 'main_address_' . $this->object['housedata']['out']['ID'];
    }

    public function getTitle()
    {
        return $this->object['name'] ?? '';
    }

    public function getFirstName()
    {
        return $this->object['housedata']['out']['address']['personFirstName'] ?? '';
    }

    public function getLastName()
    {
        return $this->object['housedata']['out']['address']['personLastName'] ?? '';
    }

    public function getPhoneNumber()
    {
        return '';
    }

    public function getEmailAddress()
    {
        return '';
    }

    public function getWebsiteAddress()
    {
        return '';
    }
}
