<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Concern\RelatedListsConstants;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\EntityListAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;

class RelatedListsAdapter implements RelatedListsAdapterInterface
{
    /**
     * @var array
     */
    protected $object;
    /**
     * @var EntityListAdapterInterface
     */
    protected $poiHighlights;

    /**
     * @var EntityListAdapterInterface[]
     */
    protected $categoryLists = [];

    public function __construct(array $object)
    {
        $this->object = $object;
        $this->poiHighlights = $this->getRelatedHighlightsList();
        $this->categoryLists = $this->getRelatedCategoryLists();
    }

    public function getHighlightsList(): ?EntityListAdapterInterface
    {
        return $this->poiHighlights;
    }

    public function getEntityLists(): array
    {
        return $this->categoryLists;
    }

    private function getRelatedHighlightsList(): EntityListAdapter
    {
        return new EntityListAdapter(
            RelatedListsConstants::TYPE_ARTICLES,
            '',
            explode('#', $this->object['object']['data_map']['poi_highlights']['remote_ids'] ?? '')
        );
    }

    private function getRelatedCategoryLists(): array
    {
        $lists = [];

        $index = 1;
        while ($this->hasRelatedCategoryListForIndex((string) $index)) {
            $list = new EntityListAdapter(
                RelatedListsConstants::TYPE_CATEGORIES,
                $this->object['object']['data_map']['list_' . $index . '_name']['name'] ?? '',
                explode('#', $this->object['object']['data_map']['list_' . $index . '_cats']['remote_ids'] ?? '')
            );
            $lists[] = $list;
            $index++;
        }

        return $lists;
    }

    private function hasRelatedCategoryListForIndex(string $index): bool
    {
        return array_key_exists('list_' . $index . '_name', $this->object['object']['data_map'])
            && array_key_exists('list_' . $index . '_cats', $this->object['object']['data_map']);
    }
}
