<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\CityApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Attributes\CityAttributes;
use Newland\Toubiz\Api\ObjectAdapter\CategoryAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\ObjectAdapter\FileAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Utility\AttributeImportUtility;

class CityAdapter extends AbstractLegacyObjectAdapter implements ArticleAdapterInterface
{
    use LanguageAware;

    public function getMainType(): int
    {
        return ArticleConstants::TYPE_CITY;
    }

    public function getExternalId(): string
    {
        return $this->object['remote_id'];
    }

    public function getName(): string
    {
        return $this->object['name'];
    }

    public function getAbstract(): ?string
    {
        return $this->object['object']['data_map']['intro']['content'] ?? null;
    }

    public function getDescription(): ?string
    {
        return $this->object['object']['data_map']['description']['content'] ?? null;
    }

    public function getLatitude(): ?float
    {
        $coordinates = explode('#', $this->object['geo'] ?? '');
        if (\count($coordinates) === 2) {
            return (float) $coordinates[0];
        }

        return null;
    }

    public function getLongitude(): ?float
    {
        $coordinates = explode('#', $this->object['geo'] ?? '');
        if (\count($coordinates) === 2) {
            return (float) $coordinates[1];
        }

        return null;
    }

    public function getMainAddress(): ?AddressAdapterInterface
    {
        return new AddressAdapter($this->object);
    }

    /**
     * @return AddressAdapterInterface[]
     */
    public function getAddresses(): array
    {
        $mainAddress = $this->getMainAddress();
        return $mainAddress ? [ $mainAddress ] : [];
    }

    /**
     * @return CategoryAdapterInterface[]
     */
    public function getCategories(): array
    {
        return [];
    }

    /**
     * @return MediumAdapterInterface[]
     */
    public function getMedia(): array
    {
        $media = [];
        if (!is_array($this->object['object']['data_map']['gallery']['content'])) {
            return $media;
        }

        foreach ($this->object['object']['data_map']['gallery']['content'] as $key => $image) {
            // Skip importing media records without a source uri.
            if (!empty($image['reference'])) {
                $media[] = new MediumAdapter($image);
            }
        }

        return $media;
    }

    /**
     * @return FileAdapterInterface[]
     */
    public function getFiles(): array
    {
        return [];
    }

    /**
     * TODO Remove method. The same data can be retrieved form `getAttributes`
     *
     * @deprecated
     * @return bool
     */
    public function hasAttributes(): bool
    {
        return !empty($this->parseAttributes());
    }

    /**
     * @return AttributeAdapterInterface[]
     */
    public function getAttributes(): array
    {
        return AttributeImportUtility::splitAttributeArrayIntoImportables(
            $this->parseAttributes(),
            function ($name, $value) {
                return new AttributeAdapter($this->getExternalId(), $name, $value);
            }
        );
    }

    private function getSocialUri(string $dataMapItemName): ?string
    {
        $value = $this->object['object']['data_map'][$dataMapItemName]['content'] ?? null;
        if (empty($value) || $this->isUrlPlaceholder($value)) {
            return null;
        }

        return (string) $value;
    }

    public function getFacebookUri(): ?string
    {
        return $this->getSocialUri('facebook');
    }

    public function getTwitterUri(): ?string
    {
        return $this->getSocialUri('twitter');
    }

    public function getInstagramUri(): ?string
    {
        return $this->getSocialUri('instagram');
    }

    public function getYoutubeUri(): ?string
    {
        return $this->getSocialUri('youtube');
    }

    public function getWikipediaUri(): ?string
    {
        return $this->getSocialUri('wikipedia');
    }

    public function getFlickrUri(): ?string
    {
        return $this->getSocialUri('flickr');
    }

    protected function isUrlPlaceholder(string $value = null): bool
    {
        return ($value === 'http://' || $value === 'https://');
    }

    public function getSourceName(): ?string
    {
        return null;
    }

    public function getAuthorName(): ?string
    {
        return $this->object['object']['author'] ?? null;
    }

    public function getBookingUri(): ?string
    {
        return null;
    }

    public function getDetailUri(): ?string
    {
        return null;
    }

    public function getOpeningTimes(): ?string
    {
        return null;
    }

    public function getOpeningTimesFormat(): ?string
    {
        return null;
    }

    public function getStarClassification(): ?int
    {
        return null;
    }

    public function getAverageRating(): ?int
    {
        return null;
    }

    public function getNumberOfRatings(): ?int
    {
        return null;
    }

    public function getRelatedLists(): ?RelatedListsAdapterInterface
    {
        return new RelatedListsAdapter($this->object);
    }

    private function parseAttributes(): array
    {
        $attributes = [];

        $childrenList = $this->getChildrenList();
        foreach ($this->extensionAttributeMapping as $extension => $mapping) {
            foreach ($mapping as $normalized => $external) {
                if (!empty($childrenList[$extension]['object']['data_map'][$external]['content'])) {
                    $attributes[$normalized] = $childrenList[$extension]['object']['data_map'][$external]['content'];
                }
            }
        }

        return $attributes;
    }

    private function getChildrenList(): array
    {
        $children = [];
        foreach ($this->object['object_children_list'] ?? [] as $child) {
            foreach ($child as $name => $content) {
                $children[$name] = $content;
            }
        }
        return $children;
    }

    private $extensionAttributeMapping = [
        'kurort_extension' => [
            CityAttributes::CURE_DESCRIPTION => 'cure_description',
            CityAttributes::CURE_REGION => 'cure_region',
            CityAttributes::CURE_ALTITUDE => 'cure_lage',
            CityAttributes::CURE_CLIMATE => 'cure_klima',
            CityAttributes::CURE_AILMENTS_TAG => 'cure_heilanzeigen_tag',
            CityAttributes::CURE_AILMENTS => 'cure_heilanzeigen',
            CityAttributes::CURE_CURES => 'cure_heilmittel',
            CityAttributes::CURE_SCREENING => 'cure_vorsorge',
            CityAttributes::CURE_COMPACT_CURE => 'cure_kompaktkur',
            CityAttributes::CURE_THERAPY => 'cure_therapie',
            CityAttributes::CURE_BATHS => 'cure_baeder',
            CityAttributes::CURE_MASSAGE => 'cure_massage',
            CityAttributes::CURE_WHOLESOME => 'cure_ganzheitlich',
            CityAttributes::CURE_VARIOUS => 'cure_sonstiges',
            CityAttributes::CURE_LABEL => 'cure_praedikat',
            CityAttributes::WEBCAM => 'webcam',
        ],
    ];
}
