<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

interface PackageAdapterInterface extends ObjectAdapterInterface
{

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @return string|null
     */
    public function getPreviewImage();

    /**
     * @return string[]
     */
    public function getBenefits(): array;

    /**
     * @return float|null
     */
    public function getMinimumNights();

    /**
     * @return float|null
     */
    public function getStartingPrice();

    /**
     * @return string|null
     */
    public function getStartingPriceCurrency();

    public function getLanguage(): ?string;
}
