<?php
namespace Newland\Toubiz\Api\Constants;

abstract class Enum
{

    /** @var array */
    protected static $constants;

    public static function validValue($value): bool
    {
        return \in_array($value, static::values(), true);
    }

    public static function throwIfInvalid($value, $exception = \InvalidArgumentException::class)
    {
        if (static::validValue($value)) {
            return;
        }

        throw new $exception(
            sprintf(
                '%s "%s" is not valid. Valid values: %s',
                static::name(),
                (string) $value,
                implode(', ', static::values())
            )
        );
    }

    public static function name(): string
    {
        $parts = explode('\\', static::class);
        return (string) array_pop($parts);
    }

    public static function values(): array
    {
        static::extractConstants();
        return array_values(static::$constants);
    }

    private static function extractConstants()
    {
        if (static::$constants) {
            return;
        }

        static::$constants = (new \ReflectionClass(static::class))->getConstants();
    }
}
