<?php
namespace Newland\ToubizApi\Tests\Service\Toubiz\Legacy\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService\CategoryAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService\PointOfInterestAdapter;
use PHPUnit\Framework\TestCase;

class PointOfInterestAdapterTest extends TestCase
{
    /**
     * @var PointOfInterestAdapter
     */
    protected $subject;

    public function setUp()
    {
        $this->subject = new PointOfInterestAdapter(new \stdClass(), new CategoryMap([]));
    }

    public function testMoveMainCategoryToTop(): void
    {
        $categories = [
            new CategoryAdapter(['remote_id' => 'foo', 'name' => 'Secondary Category A']),
            new CategoryAdapter(['remote_id' => 'baz', 'name' => 'Main Category']),
            new CategoryAdapter(['remote_id' => 'bar', 'name' => 'Secondary Category B']),
        ];

        $mainCategoryId = 'baz';

        $categories = $this->subject->moveMainCategoryToTop($categories, $mainCategoryId);

        $this->assertEquals('baz', $categories[0]->getExternalId());
    }
}
