<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Service collection.
 *
 * A collection of services that is being attached to a repository. The
 * collection provides methods to access the correct service based on
 * the data that is requested.
 */
class ServiceCollection
{
    /**
     * @var array
     */
    protected $services = [];

    /**
     * Add a configured service instance to a collection.
     *
     * @todo param interface?
     * @return void
     */
    public function addService($service)
    {
        $this->services[] = $service;
    }

    /**
     * Get service that supports the given object name.
     *
     * @param string $objectName
     * @return mixed
     */
    public function getServiceForObjectName($objectName)
    {
        foreach ($this->services as $service) {
            if (array_key_exists($objectName, $service::OBJECTS)) {
                return $service;
            }
        }
    }
}
