<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy;

use Newland\Toubiz\Api\Constants\Language;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMap;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\DbService\CategoryMapParser;
use function Safe\sprintf;

trait SharedLegacyToubizServiceBehaviour
{
    protected $categoryMapCsv = '/../../../../Resources/Service/Toubiz/Legacy/DbService/categories-poi.csv';

    /**
     * Map of language constants to URI segments expected by the API.
     *
     * @var array
     */
    protected static $languageMap = [
        Language::DE => 'ger-DE',
        Language::EN => 'eng-GB',
        Language::FR => 'fre-FR',
        Language::ES => 'esl-ES',
    ];

    protected function buildUrl(array $parameters): string
    {
        $parameters['key'] = $parameters['key'] ?? $this->apiKey;

        $url = '/layout/set/json/content/view/json/' . $this->clientName;

        foreach ($parameters as $key => $value) {
            $url .= sprintf('/(%s)/%s', $key, $value);
        }

        if ($this->language) {
            $url .= '/(lang)/' . static::$languageMap[$this->language];
        }

        return $url;
    }


    /**
     * The category map is built from a static csv export from Toubiz Legacy.
     * This should be updated when new categories are added in Toubiz Legacy Backend.
     */
    protected function getCategoryMap(): CategoryMap
    {
        $file = __DIR__ . $this->categoryMapCsv;
        return (new CategoryMapParser())->parse($file, (string) $this->language);
    }

}
