<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\TourApiService;

use Newland\Toubiz\Api\ObjectAdapter\Attributes\TourAttributes;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService\PointOfInterestAdapter;

/**
 * TODO Extending PointOfInterestAdapter is not clean.
 * We should extract common logic into a trait or something similar.
 */
class TourAdapter extends PointOfInterestAdapter
{
    public function getMainType(): int
    {
        return ArticleConstants::TYPE_TOUR;
    }

    protected function parseAttributes(): array
    {
        $attributes = parent::parseAttributes();
        $attributes[TourAttributes::DATA_SOURCE] = TourAttributes::DATA_SOURCE_TOUBIZ_LEGACY;

        $length = $this->object['object']['data_map']['length']['content'] ?? null;
        if ($length) {
            $attributes[TourAttributes::TOUR_LENGTH] = $length * 1000;
        }
        $duration = $this->object['object']['data_map']['duration']['content'] ?? null;
        if ($duration) {
            $attributes[TourAttributes::TOUR_DURATION] = $duration * 60;
        }

        return $attributes;
    }

    protected $dataMapMapping = [
        TourAttributes::STARTING_POINT => 'startingpoint',
        TourAttributes::ENDING_POINT => 'endpoint',
        TourAttributes::TECHNIQUE_RATING => 'severity',
        TourAttributes::LANDSCAPE_RATING => 'beauty',
        TourAttributes::DIFFICULTY_RATING => 'degree_of_difficulty',
        TourAttributes::CONDITION_RATING => 'fitness',
        TourAttributes::MAXIMUM_ALTITUDE => 'highestpoint',
        TourAttributes::ASCEND_ELEVATION => 'uphill',
        TourAttributes::DESCENT_ELEVATION => 'downhill',
        TourAttributes::EXPERIENCE_RATING => 'popularity',
        TourAttributes::SAFETY_NOTE => 'special',

        // Note: Not all attributes are in toubiz tours available!
        TourAttributes::ISCLOSED => null,
        TourAttributes::PRIVATE_TRANSIT => null,
        TourAttributes::PUBLIC_TRANSIT => null,
        TourAttributes::MINIMUM_ALTITUDE => null,
        TourAttributes::GEOMETRY => null,
        TourAttributes::NECESARRY_EQUIPMENT => null,
        TourAttributes::BEST_SEASON => null,
        TourAttributes::DIRECTIONS => null,
        TourAttributes::PARKING => null,
        TourAttributes::ADDITIONAL_INFORMATION => null,
        TourAttributes::HINT_OF_AUTHOR => null,
    ];

    protected $extensionAttributeMapping = [];
}
