<?php
namespace Newland\Toubiz\Api\ObjectAdapter\Article;

use Newland\Toubiz\Api\ObjectAdapter\RelatedLists\RelatedListsAdapterInterface;

interface ArticleTypeCityAdapterInterface
{
    /**
     * Returns an object of lists with related records (articles, categories, etc)
     *
     * @return RelatedListsAdapterInterface|null
     */
    public function getRelatedLists(): ?RelatedListsAdapterInterface;

    /**
     * Cities have a list of zip codes. This is important for filtering by city.
     *
     * @return string[]
     */
    public function getZipCodes(): array;

    /**
     * The id from the toubiz system. Needed for filtering of tportal event lists.
     *
     * @return string
     */
    public function getIdToubiz(): string;

    /**
     * The id from the tomas system. Needed for filtering of tportal lodging lists.
     *
     * @return string
     */
    public function getIdTomas(): string;

    /**
     * The claim field from the Cities
     */
    public function getClaim(): string;

    /**
     * The facts field from the Cities
     */
    public function getFacts(): string;

    /**
     * The webcam field from the Cities
     */
    public function getWebcam(): string;
}
