<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\LegacyToubizAddressAdapterCommon;

class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        // There is not really an id for this.
        return (string) $this->object['object']['id'];
    }

    public function getTitle(): ?string
    {
        return $this->object['object']['data_map']['address_title']['content'] ?? null;
    }

    public function getFirstName(): ?string
    {
        return null;
    }

    public function getLastName(): ?string
    {
        return null;
    }

    public function getStreet(): ?string
    {
        return $this->object['object']['data_map']['street']['content'] ?? null;
    }

    public function getZip(): ?string
    {
        return $this->object['object']['data_map']['zip']['content'] ?? null;
    }

    public function getCity(): ?string
    {
        return $this->object['object']['data_map']['city']['content']
            ?? $this->object['city']
            ?? null;
    }

    public function getCountry(): ?string
    {
        return null;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->object['object']['data_map']['phone']['content'] ?? null;
    }

    public function getFaxNumber(): ?string
    {
        return $this->object['object']['data_map']['fax']['content'] ?? null;
    }

    public function getEmailAddress(): ?string
    {
        return $this->object['object']['data_map']['email']['content'] ?? null;
    }

    public function getWebsiteAddress(): ?string
    {
        $url = $this->object['object']['data_map']['url']['content'] ?? null;

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (strpos($url, 'http') !== 0) {
            $url = 'http://' . $url;
        }

        return $url;
    }

    public function getLatitude(): ?float
    {
        if (strpos($this->object['geo'], '#') !== false) {
            [$latitude] = explode('#', $this->object['geo']);
            return ((float) $latitude) ?: null;
        }

        return null;
    }

    public function getLongitude(): ?float
    {
        if (strpos($this->object['geo'], '#') !== false) {
            [, $longitude] = explode('#', $this->object['geo']);
            return ((float) $longitude) ?: null;
        }
        return null;
    }

    public function isLookup(): bool
    {
        return true;
    }
}
