<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ServiceConstants;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\PackageAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\ServiceAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Utility\UrlUtility;
use function Safe\preg_match_all;

class PackageAdapter extends AbstractObjectAdapter implements ServiceAdapterInterface
{
    use LanguageAware, MediaCommon;

    /** @var null|string */
    private $detailUriTemplate;

    public function setDetailUriTemplate(?string $detailUriTemplate): void
    {
        $this->detailUriTemplate = $detailUriTemplate;
    }

    /**
     * Returns the external id used by the API
     * to identify the record.
     *
     * @return string
     */
    public function getExternalId(): string
    {
        return strip_tags((string) ($this->object['package']['packageID'] ?? ''));
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return strip_tags((string) ($this->object['package']['packageName'] ?? ''));
    }

    /**
     * @return string[]
     */
    public function getBenefits(): array
    {
        $description = $this->getDescription('DESCRIPTION_INCLUDED_SERVICES');

        if ($description === null) {
            return [];
        }

        preg_match_all('/<li>(.*?)<\/li>/', $description, $matches);
        return array_map(
            function (string $item) {
                return trim(strip_tags($item));
            },
            $matches[1] ?? []
        );
    }

    /**
     * @return float|null
     */
    public function getMinimumNights(): ?float
    {
        return $this->object['package']['minimumNights'] ?? null;
    }

    /**
     * @return float|null
     */
    public function getStartingPrice(): ?float
    {
        $group = $this->getFeatureGroup('packageprice');
        if ($group) {
            return $group['features']['number'] ?? null;
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getStartingPriceCurrency(): ?string
    {
        return 'EUR';
    }

    private function getFeatureGroup(string $externalId)
    {
        foreach ($this->object['serviceData']['featureGroups'] ?? [] as $featureGroup) {
            $featureExternalId = $featureGroup['features']['value']['externalID'] ?? null;
            if ($externalId === $featureExternalId) {
                return $featureGroup;
            }
        }
        return null;
    }

    private function getDescription(string $externalId): ?string
    {
        foreach ($this->object['serviceData']['descriptions'] ?? [] as $description) {
            $descriptionExternalId = $description['externalID'] ?? null;
            if ($externalId === $descriptionExternalId) {
                return $description['description'];
            }
        }
        return null;
    }

    public function getDetailUri(): string
    {
        if (!$this->detailUriTemplate) {
            return '#';
        }

        $niceUrl = $this->object['serviceData']['niceUrl'] ?? null;
        if (!$niceUrl) {
            return '#';
        }

        $niceUrl = ltrim($niceUrl, '/');
        $languageSegment = $this->getLanguage() ?? 'de';

        return str_replace(
            [ '{tportalUriSegment}', '{languageSegment}' ],
            [ $niceUrl, $languageSegment ],
            $this->detailUriTemplate
        );
    }

    public function getType(): string
    {
        return ServiceConstants::TYPE_PACKAGE;
    }

    public function getDurationMinutes(): ?int
    {
        return null;
    }

    public function getAddress(): ?string
    {
        return null;
    }
}
