<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ServiceConstants;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\ServiceAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;

class GuideAdapter extends AbstractObjectAdapter implements ServiceAdapterInterface
{
    use LanguageAware, MediaCommon;

    /** @var string|null */
    private $detailUriTemplate;

    public function getExternalId(): string
    {
        return (string) ($this->object['guide']['packageID'] ?? '');
    }

    public function setDetailUriTemplate(?string $template): void
    {
        $this->detailUriTemplate = $template;
    }

    public function getDetailUri(): string
    {
        if (!$this->detailUriTemplate) {
            return '#';
        }

        $tportalUriSegment = sprintf('%s/guide/detail/%s', $this->object['client'], $this->getExternalId());
        $languageSegment = $this->getLanguage() ?? 'de';

        return str_replace(
            [ '{tportalUriSegment}', '{languageSegment}' ],
            [ $tportalUriSegment, $languageSegment ],
            $this->detailUriTemplate
        );
    }
    public function getType(): string
    {
        return ServiceConstants::TYPE_GUIDE;
    }

    public function getName(): string
    {
        return (string) ($this->object['guide']['packageName'] ?? '');
    }

    public function getMinimumNights(): ?float
    {
        return null;
    }

    public function getStartingPrice(): ?float
    {
        return null;
    }

    public function getStartingPriceCurrency(): ?string
    {
        return null;
    }

    public function getDurationMinutes(): ?int
    {
        foreach ($this->object['serviceData']['dataClassAttributeValues'] ?? [] as $attribute) {
            if (($attribute['twsDataClassAttribute']['name'] ?? null) === 'Duration') {
                $formatted = $attribute['stringValues'];
                if (strpos($formatted, ':') === false) {
                    continue;
                }
                [ $hours, $minutes ] = explode(':', $formatted);
                return ((int) $hours) * 60 + ((int) $minutes);
            }
        }
        return null;
    }

    public function getAddress(): ?string
    {
        foreach ($this->object['guide']['descriptions'] ?? [] as $description) {
            if (($description['descriptionTypeName'] ?? null) === 'Treffpunkt') {
                return (string) $description['descriptionPlainText'];
            }
        }
        return null;
    }

    /** @return string[] */
    public function getBenefits(): array
    {
        return [];
    }
}
