<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DirectMarketerApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return md5($this->object['imageURL']);
    }

    public function getSourceUri(): string
    {
        $uri = $this->object['imageURL'] ?? '';
        $uri = $uri ?: ($this->object['imageURLsmall'] ?? '');
        return strip_tags((string) $uri);
    }

    public function getCopyright(): ?string
    {
        return null;
    }

    public function getTitle(): ?string
    {
        $description = $this->object['description'][0]['text'] ?? null;
        return $description ? strip_tags((string) $description) : null;
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getPreviewUri(): ?string
    {
        return null;
    }
}
