<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['id_image']);
    }

    public function getSourceUri(): string
    {
        $uri = $this->object['imageURL'] ?? '';
        $uri = $uri ?: ($this->object['imageURL'] ?? '');
        return strip_tags($uri);
    }

    public function getCopyright(): ?string
    {
        if ($this->object['description']
            && array_key_exists('text', $this->object['description'][0])
        ) {
            $copyright = $this->object['description'][0]['text'] ?? null;
            return $copyright ? strip_tags((string) $copyright) : null;
        }

        return null;
    }

    public function getTitle(): ?string
    {
        if ($this->object['description']
            && array_key_exists('text', $this->object['description'])
        ) {
            $title = $this->object['description']['text'] ?? null;
            return $title ? strip_tags((string) $title) : null;
        }

        return null;
    }
}
