<?php

namespace Newland\Toubiz\Api\Service\GpsParser;

abstract class Parser
{
    public static function resolveParser(string $file): ?Parser
    {
        $extension = pathinfo($file)['extension'] ?? null;

        switch ($extension) {
            case 'kml':
                return new KmlParser();
                break;
            case 'gpx':
                return new GpxParser();
                break;
            default:
                return null;
        }
    }

    /**
     * Concrete implementation of the track extraction.
     *
     * @param string $file
     * @return array
     */
    abstract public function extractTrack(string $file): array;

    /**
     * This function can be given a GPS file and will transform it into a multidimensional array
     */
    protected function parseXmlAsAssociativeArray(string $file): array
    {
        $array = [];
        $fileContents = file_get_contents($file) ?? '';
        // Loading the GPX data
        $xml = simplexml_load_string((string) $fileContents);

        // Json conversion
        $json = (string) json_encode($xml);
        // Array conversion
        $array = json_decode($json, true);

        return $array;
    }
}
