<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\OfferAdapterInterface;

class OfferAdapter extends AbstractObjectAdapter implements OfferAdapterInterface
{
    public function getExternalId(): string
    {
        return $this->object['offer']['serviceID'];
    }

    public function getName(): string
    {
        return $this->object['offer']['serviceDescribingName'];
    }

    public function getPreviewImage()
    {
        return $this->object['offer']['previewImageURL'];
    }

    public function getStartingPrice()
    {
        $price = $this->extractMinimumPrice();
        return $price ? $price['value'] : null;
    }

    public function getStartingPriceCurrency()
    {
        $price = $this->extractMinimumPrice();
        return $price ? $price['currency'] : null;
    }

    public function getAddress()
    {
        $address = strip_tags($this->object['geoResult']['address']);
        return $address !== '' ? $address : null;
    }

    public function getDurationMinutes()
    {
        return null;
    }

    private function extractMinimumPrice()
    {
        $price = null;
        foreach ($this->object['availability'] as $availability) {
            if (!$availability || !$availability['minimumBasePrice']) {
                continue;
            }

            if (!$price) {
                $price = $availability['minimumBasePrice'];
            } elseif ($availability['minimumBasePrice']['value'] < $price['value']) {
                $price = $availability['minimumBasePrice'];
            }
        }
        return $price;
    }
}
